/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.model.HTTPHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Location {
    private static final Logger log = LoggerFactory.getLogger(Location.class);

    public static boolean isHTTP(URL url) {
        return url.getProtocol().toLowerCase().equals("http") || url.getProtocol().toLowerCase().equals("https");
    }

    public static boolean isFile(URL url) {
        return url.getProtocol().toLowerCase().equals("file");
    }

    public static InputStream getInputStream(URL url, Properties properties) throws IllegalArgumentException, IOException {
        Object local = null;
        if (url.getProtocol().equals("file")) {
            log.debug("Getting input stream from file");
            return url.openStream();
        }
        if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
            CloseableHttpResponse response = HTTPHelper.getInputStream((URL)url, (Properties)properties);
            if (!HTTPHelper.isSuccessful((CloseableHttpResponse)response)) {
                throw new IOException(response.getStatusLine().toString());
            }
            return response.getEntity().getContent();
        }
        log.debug("Other protocol: {}", (Object)url.getProtocol());
        return url.openStream();
    }
}

