/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.model.HTTPHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache {
    private static final Logger log = LoggerFactory.getLogger(LocalCache.class);
    public static final String DIRNAME = ".fx";
    private File location;

    public LocalCache() {
        this(System.getProperty("user.home"));
    }

    public LocalCache(String baseDir) {
        File userHome = new File(baseDir);
        if (!userHome.isDirectory()) {
            throw new RuntimeException("Not a directory: " + String.valueOf(userHome));
        }
        this.location = new File(userHome, DIRNAME);
    }

    public File getLocation() {
        return this.location;
    }

    public File download(URL url, Properties properties) throws IllegalArgumentException, IOException {
        File local = null;
        if (url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Cannot download a local file");
        }
        if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
            log.debug("Downloading via HTTP Client");
            HttpClientBuilder builder = HTTPHelper.setupClientBuilder((URL)url, (Properties)properties);
            CloseableHttpClient client = builder.build();
            HttpUriRequest request = HTTPHelper.buildRequest((URL)url, (Properties)properties);
            CloseableHttpResponse response = client.execute(request);
            System.err.println(response.getStatusLine().getStatusCode());
        }
        return local;
    }

    public File find(URL url, Properties properties) throws IllegalArgumentException {
        File local = null;
        return local;
    }

    public File find(URL url) throws IllegalArgumentException {
        File local = null;
        return local;
    }

    public boolean delete(URL url, Properties properties) throws IllegalArgumentException {
        Boolean found = false;
        return found;
    }
}

