/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.DatasetGraphCreator;
import io.github.sparqlanything.engine.FXWorkerOp;
import io.github.sparqlanything.engine.FXWorkerOpService;
import io.github.sparqlanything.engine.FacadeXExecutionContext;
import io.github.sparqlanything.engine.UnboundVariableException;
import io.github.sparqlanything.engine.Utils;
import io.github.sparqlanything.model.SPARQLAnythingConstants;
import io.github.sparqlanything.model.TriplifierHTTPException;
import io.github.sparqlanything.model.TriplifierRegister;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.optimize.TransformPropertyFunction;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterAssign;
import org.apache.jena.sparql.engine.join.Join;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacadeXOpExecutor
extends OpExecutor {
    public static final Symbol strategy = Symbol.create((String)"facade-x-strategy");
    private static final Logger logger = LoggerFactory.getLogger(FacadeXOpExecutor.class);
    private final FXWorkerOpService fxWorkerOpService;
    private final FXWorkerOp fxWorkerOp;

    public FacadeXOpExecutor(ExecutionContext execCxt) {
        super(execCxt);
        TriplifierRegister triplifierRegister = TriplifierRegister.getInstance();
        DatasetGraphCreator dgc = new DatasetGraphCreator(execCxt);
        this.fxWorkerOpService = new FXWorkerOpService(triplifierRegister, dgc);
        this.fxWorkerOp = new FXWorkerOp(triplifierRegister, dgc);
    }

    protected QueryIterator exec(Op op, QueryIterator input) {
        if (this.execCxt.getContext().isDefined(SPARQLAnythingConstants.NO_SERVICE_MODE) && this.execCxt.getContext().getTrueOrFalse(SPARQLAnythingConstants.NO_SERVICE_MODE).booleanValue()) {
            try {
                this.execCxt.getContext().setFalse(SPARQLAnythingConstants.NO_SERVICE_MODE);
                return this.fxWorkerOp.execute(op, input, this.execCxt);
            }
            catch (UnboundVariableException | TriplifierHTTPException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return super.exec(op, input);
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        logger.trace("Execute OpBGP {}", (Object)opBGP.getPattern().toString());
        if (this.execCxt.getClass() == FacadeXExecutionContext.class) {
            logger.trace("FacadeX Execution context");
            List<Triple> magicPropertyTriples = Utils.getFacadeXMagicPropertyTriples(opBGP.getPattern());
            if (!magicPropertyTriples.isEmpty()) {
                logger.trace("BGP has magic properties");
                return super.execute(Utils.excludeMagicPropertyTriples(Utils.excludeFXProperties(opBGP)), this.executeMagicProperties(input, magicPropertyTriples, this.execCxt));
            }
            logger.trace("Execute BGP by excluding FX properties");
            return QC.execute((Op)Utils.excludeFXProperties(opBGP), (QueryIterator)input, (ExecutionContext)new ExecutionContext(ARQ.getContext(), this.execCxt.getActiveGraph(), this.execCxt.getDataset(), this.execCxt.getExecutor()));
        }
        Op opTransformed = TransformPropertyFunction.transform((Op)opBGP, (Context)this.execCxt.getContext());
        if (!opTransformed.equals(opBGP)) {
            return super.executeOp(opTransformed, input);
        }
        logger.trace("Execute with default Jena execution");
        return super.execute(opBGP, input);
    }

    protected QueryIterator execute(OpService opService, QueryIterator input) {
        logger.trace("Execute opService {}", (Object)opService.toString());
        if (!this.execCxt.getContext().isDefined(SPARQLAnythingConstants.NO_SERVICE_MODE)) {
            if (opService.getService().isVariable()) {
                return Utils.postpone((Op)opService, input, this.execCxt);
            }
            if (Utils.isFacadeXServiceNode(opService)) {
                try {
                    return this.fxWorkerOpService.execute(opService, input, this.execCxt);
                }
                catch (TriplifierHTTPException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("An error occurred: {}", (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
                catch (UnboundVariableException e) {
                    return this.catchUnboundVariableException((Op)opService, e.getOpBGP(), input, e);
                }
            }
        }
        return super.execute(opService, input);
    }

    private QueryIterator catchUnboundVariableException(Op op, OpBGP opBGP, QueryIterator input, UnboundVariableException e) {
        OpBGP fakeBGP = Utils.extractFakePattern(opBGP);
        if (e.getOpTable() != null) {
            logger.trace("Executing table");
            QueryIterator qIterT = e.getOpTable().getTable().iterator(this.execCxt);
            QueryIterator qIter = Join.join((QueryIterator)input, (QueryIterator)qIterT, (ExecutionContext)this.execCxt);
            return Utils.postpone(op, qIter, this.execCxt);
        }
        if (e.getOpExtend() != null) {
            logger.trace("Executing op extend");
            QueryIterator qIter = this.exec(e.getOpExtend().getSubOp(), input);
            qIter = new QueryIterAssign(qIter, e.getOpExtend().getVarExprList(), this.execCxt, true);
            return Utils.postpone(op, qIter, this.execCxt);
        }
        logger.trace("Executing fake pattern {}", (Object)fakeBGP);
        return Utils.postpone(op, QC.execute((Op)fakeBGP, (QueryIterator)input, (ExecutionContext)this.execCxt), this.execCxt);
    }

    private QueryIterator executeMagicProperties(QueryIterator input, List<Triple> propFuncTriples, ExecutionContext execCxt) {
        QueryIterator input2 = input;
        for (Triple t : propFuncTriples) {
            input2 = QC.execute((Op)Utils.getOpPropFuncAnySlot(t), (QueryIterator)input2, (ExecutionContext)execCxt);
        }
        return input2;
    }
}

