/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import info.debatty.java.stringsimilarity.Cosine;
import info.debatty.java.stringsimilarity.QGram;
import io.github.sparqlanything.engine.AnySlot;
import io.github.sparqlanything.engine.FacadeXOpExecutor;
import io.github.sparqlanything.engine.functions.After;
import io.github.sparqlanything.engine.functions.Backward;
import io.github.sparqlanything.engine.functions.Before;
import io.github.sparqlanything.engine.functions.Bnode;
import io.github.sparqlanything.engine.functions.Cardinal;
import io.github.sparqlanything.engine.functions.Entity;
import io.github.sparqlanything.engine.functions.Forward;
import io.github.sparqlanything.engine.functions.IsContainerMembershipProperty;
import io.github.sparqlanything.engine.functions.IsFacadeXExtension;
import io.github.sparqlanything.engine.functions.Literal;
import io.github.sparqlanything.engine.functions.Next;
import io.github.sparqlanything.engine.functions.Previous;
import io.github.sparqlanything.engine.functions.RemoveTags;
import io.github.sparqlanything.engine.functions.Serial;
import io.github.sparqlanything.engine.functions.reflection.ReflectionFunctionFactory;
import io.github.sparqlanything.model.TriplifierRegister;
import io.github.sparqlanything.model.TriplifierRegisterException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.text.WordUtils;
import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.JaccardDistance;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacadeX {
    public static final OpExecutorFactory ExecutorFactory = FacadeXOpExecutor::new;
    public static final TriplifierRegister Registry = TriplifierRegister.getInstance();
    public static final String ANY_SLOT_URI = "http://sparql.xyz/facade-x/ns/anySlot";
    private static final Logger log = LoggerFactory.getLogger(FacadeX.class);
    static final Map<String, DatasetGraph> executedFacadeXIris = new HashMap<String, DatasetGraph>();

    public static void enablingMagicProperties() {
        log.trace("Enabling magic properties");
        ARQ.setTrue((Symbol)ARQ.enablePropertyFunctions);
        PropertyFunctionFactory p = uri -> {
            log.trace("Creating any slot");
            return new AnySlot();
        };
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.chooseRegistry((Context)ARQ.getContext());
        reg.put(ANY_SLOT_URI, p);
        if (log.isTraceEnabled()) {
            Iterator i = reg.keys();
            while (i.hasNext()) {
                log.trace("Registering magic property: {}", i.next());
            }
        }
        PropertyFunctionRegistry.set((Context)ARQ.getContext(), (PropertyFunctionRegistry)reg);
    }

    public static void enablingFunctions() {
        log.trace("Enabling functions");
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/entity", Entity.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/literal", Literal.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/bnode", Bnode.class);
        log.trace("Enabling collection functions");
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/previous", Previous.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/next", Next.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/before", Before.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/after", After.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/backward", Backward.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/forward", Forward.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/cardinal", Cardinal.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/isContainerMembershipProperty", IsContainerMembershipProperty.class);
        log.trace("Enabling String functions");
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.trim", ReflectionFunctionFactory.get().makeFunction(String.class, "trim"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.substring", ReflectionFunctionFactory.get().makeFunction(String.class, "substring"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.indexOf", ReflectionFunctionFactory.get().makeFunction(String.class, "indexOf"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.startsWith", ReflectionFunctionFactory.get().makeFunction(String.class, "startsWith"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.endsWith", ReflectionFunctionFactory.get().makeFunction(String.class, "endsWith"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.replace", ReflectionFunctionFactory.get().makeFunction(String.class, "replace"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.strip", ReflectionFunctionFactory.get().makeFunction(String.class, "strip"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.stripLeading", ReflectionFunctionFactory.get().makeFunction(String.class, "stripLeading"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.stripTrailing", ReflectionFunctionFactory.get().makeFunction(String.class, "stripTrailing"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.removeTags", RemoveTags.class);
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.lastIndexOf", ReflectionFunctionFactory.get().makeFunction(String.class, "lastIndexOf"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.md2Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "md2Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.md5Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "md5Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.sha1Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "sha1Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.sha256Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "sha256Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.sha384Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "sha384Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/DigestUtils.sha512Hex", ReflectionFunctionFactory.get().makeFunction(DigestUtils.class, "sha512Hex"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/WordUtils.capitalize", ReflectionFunctionFactory.get().makeFunction(WordUtils.class, "capitalize"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/WordUtils.capitalizeFully", ReflectionFunctionFactory.get().makeFunction(WordUtils.class, "capitalizeFully"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/WordUtils.initials", ReflectionFunctionFactory.get().makeFunction(WordUtils.class, "initials"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/WordUtils.swapCase", ReflectionFunctionFactory.get().makeFunction(WordUtils.class, "swapCase"));
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/WordUtils.uncapitalize", ReflectionFunctionFactory.get().makeFunction(WordUtils.class, "uncapitalize"));
        try {
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.toLowerCase", ReflectionFunctionFactory.get().makeFunction(String.class.getMethod("toLowerCase", new Class[0])));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/String.toUpperCase", ReflectionFunctionFactory.get().makeFunction(String.class.getMethod("toUpperCase", new Class[0])));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/URLEncoder.encode", ReflectionFunctionFactory.get().makeFunction(URLEncoder.class.getMethod("encode", String.class, String.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/URLDecoder.decode", ReflectionFunctionFactory.get().makeFunction(URLDecoder.class.getMethod("decode", String.class, String.class)));
        }
        catch (NoSuchMethodException e) {
            log.error("", (Throwable)e);
        }
        try {
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/LevenshteinDistance", ReflectionFunctionFactory.get().makeFunction(true, LevenshteinDistance.class.getMethod("apply", CharSequence.class, CharSequence.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/JaccardDistance", ReflectionFunctionFactory.get().makeFunction(true, JaccardDistance.class.getMethod("apply", CharSequence.class, CharSequence.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/JaroWinklerDistance", ReflectionFunctionFactory.get().makeFunction(true, JaroWinklerDistance.class.getMethod("apply", CharSequence.class, CharSequence.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/LongestCommonSubsequenceDistance", ReflectionFunctionFactory.get().makeFunction(true, LongestCommonSubsequenceDistance.class.getMethod("apply", CharSequence.class, CharSequence.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/HammingDistance", ReflectionFunctionFactory.get().makeFunction(true, HammingDistance.class.getMethod("apply", CharSequence.class, CharSequence.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/QGramDistance", ReflectionFunctionFactory.get().makeFunction(true, QGram.class.getMethod("distance", String.class, String.class)));
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/CosineDistance", ReflectionFunctionFactory.get().makeFunction(true, Cosine.class.getMethod("distance", String.class, String.class)));
        }
        catch (NoSuchMethodException e) {
            log.error("", (Throwable)e);
        }
        log.trace("Enabling function `serial`");
        FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/serial", Serial.class);
    }

    static {
        try {
            log.trace("Registering isFacadeXExtension function");
            FunctionRegistry.get().put("http://sparql.xyz/facade-x/ns/isFacadeXExtension", IsFacadeXExtension.class);
            FacadeX.enablingMagicProperties();
            FacadeX.enablingFunctions();
            log.trace("Registering standard triplifiers");
            Registry.registerTriplifier("io.github.sparqlanything.bib.BibtexTriplifier", new String[]{"bib", "bibtex"}, new String[]{"application/x-bibtex"});
            Registry.registerTriplifier("io.github.sparqlanything.xml.XMLTriplifier", new String[]{"xml", "svg", "svgz"}, new String[]{"application/xml", "text/xml", "image/svg+xml"});
            Registry.registerTriplifier("io.github.sparqlanything.csv.CSVTriplifier", new String[]{"csv", "tsv", "tab"}, new String[]{"text/csv", "text/tab-separated-values"});
            Registry.registerTriplifier("io.github.sparqlanything.html.HTMLTriplifier", new String[]{"html"}, new String[]{"text/html"});
            Registry.registerTriplifier("io.github.sparqlanything.text.TextTriplifier", new String[]{"txt"}, new String[]{"text/plain"});
            Registry.registerTriplifier("io.github.sparqlanything.markdown.MARKDOWNTriplifier", new String[]{"md"}, new String[]{"text/markdown", "text/x-markdown"});
            Registry.registerTriplifier("io.github.sparqlanything.docs.DocxTriplifier", new String[]{"docx"}, new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document"});
            Registry.registerTriplifier("io.github.sparqlanything.zip.TarTriplifier", new String[]{"tar"}, new String[]{"application/x-tar"});
            Registry.registerTriplifier("io.github.sparqlanything.zip.ZipTriplifier", new String[]{"zip"}, new String[]{"application/zip"});
            Registry.registerTriplifier("io.github.sparqlanything.binary.BinaryTriplifier", new String[]{"bin", "dat"}, new String[]{"application/octet-stream"});
            Registry.registerTriplifier("io.github.sparqlanything.json.JSONTriplifier", new String[]{"json"}, new String[]{"application/json", "application/problem+json"});
            Registry.registerTriplifier("io.github.sparqlanything.yaml.YAMLTriplifier", new String[]{"yaml"}, new String[]{"application/yaml", "text/yaml", "x-text/yaml"});
            Registry.registerTriplifier("io.github.sparqlanything.spreadsheet.SpreadsheetTriplifier", new String[]{"xls", "xlsx"}, new String[]{"application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"});
            Registry.registerTriplifier("io.github.sparqlanything.rdf.RDFTriplifier", new String[]{"rdf", "ttl", "nt", "jsonld", "owl", "trig", "nq", "trix", "trdf"}, new String[]{"application/rdf+thrift", "application/trix+xml", "application/n-quads", "text/trig", "application/owl+xml", "text/turtle", "application/rdf+xml", "application/n-triples", "application/ld+json"});
            Registry.registerTriplifier("io.github.sparqlanything.binary.BinaryTriplifier", new String[]{"png", "jpeg", "jpg", "bmp", "tiff", "tif", "ico"}, new String[]{"image/png", "image/jpeg", "image/bmp", "image/tiff", "image/vnd.microsoft.icon"});
            Registry.registerTriplifier("io.github.sparqlanything.slides.PptxTriplifier", new String[]{"pptx"}, new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation"});
        }
        catch (TriplifierRegisterException e) {
            throw new RuntimeException(e);
        }
    }
}

