/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.DatasetGraphCreator;
import io.github.sparqlanything.engine.FXBGPFinder;
import io.github.sparqlanything.engine.FXWorker;
import io.github.sparqlanything.engine.PropertyExtractor;
import io.github.sparqlanything.engine.UnboundVariableException;
import io.github.sparqlanything.engine.Utils;
import io.github.sparqlanything.facadeiri.FacadeIRIParser;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.TriplifierRegister;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.main.QC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXWorkerOpService
extends FXWorker<OpService> {
    private static final Logger logger = LoggerFactory.getLogger(FXWorkerOpService.class);

    public FXWorkerOpService(TriplifierRegister tr, DatasetGraphCreator dgc) {
        super(tr, dgc);
    }

    @Override
    public QueryIterator execute(OpService op, QueryIterator input, ExecutionContext executionContext, DatasetGraph dg, Properties p) {
        return QC.execute((Op)Algebra.optimize((Op)op.getSubOp()), (QueryIterator)input, (ExecutionContext)Utils.getFacadeXExecutionContext(executionContext, p, dg));
    }

    @Override
    public void extractProperties(Properties properties, OpService opService) throws UnboundVariableException {
        String url = opService.getService().getURI();
        if (!url.equals("x-sparql-anything:")) {
            FacadeIRIParser p = new FacadeIRIParser(url);
            properties.putAll((Map<?, ?>)p.getProperties());
        }
        if (!properties.containsKey(IRIArgument.NAMESPACE.toString())) {
            logger.trace("Setting default value for namespace: {}", (Object)"http://sparql.xyz/facade-x/data/");
            properties.setProperty(IRIArgument.NAMESPACE.toString(), "http://sparql.xyz/facade-x/data/");
        }
        if (opService.getSilent()) {
            properties.setProperty(IRIArgument.OP_SERVICE_SILENT.toString(), "true");
        }
        Op next = opService.getSubOp();
        FXBGPFinder vis = new FXBGPFinder();
        next.visit((OpVisitor)vis);
        logger.trace("Has Table {}", (Object)vis.hasTable());
        if (vis.getBGP() != null) {
            try {
                PropertyExtractor.extractPropertiesFromBGP(properties, vis.getBGP());
            }
            catch (UnboundVariableException e) {
                if (vis.hasTable()) {
                    logger.trace(vis.getOpTable().toString());
                    logger.trace("BGP {}", (Object)vis.getBGP());
                    logger.trace("Contains variable names {}", (Object)vis.getOpTable().getTable().getVarNames().contains(e.getVariableName()));
                    if (vis.getOpTable().getTable().getVarNames().contains(e.getVariableName())) {
                        e.setOpTable(vis.getOpTable());
                    }
                }
                if (vis.getOpExtend() != null) {
                    logger.trace("OpExtend {}", (Object)vis.getOpExtend());
                    for (Var var : vis.getOpExtend().getVarExprList().getVars()) {
                        if (!var.getName().equals(e.getVariableName())) continue;
                        e.setOpExtend(vis.getOpExtend());
                    }
                }
                throw e;
            }
            logger.trace("Number of properties {}: {}", (Object)properties.size(), (Object)properties);
        } else {
            logger.trace("Couldn't find OpGraph");
        }
    }
}

