/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.DatasetGraphCreator;
import io.github.sparqlanything.engine.FXWorkerOpService;
import io.github.sparqlanything.engine.PropertyExtractor;
import io.github.sparqlanything.engine.QueryIterSlicer;
import io.github.sparqlanything.engine.UnboundVariableException;
import io.github.sparqlanything.engine.Utils;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.Slicer;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.model.TriplifierHTTPException;
import io.github.sparqlanything.model.TriplifierRegister;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Scanner;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FXWorker<T extends Op> {
    private static final Logger logger = LoggerFactory.getLogger(FXWorkerOpService.class);
    private final TriplifierRegister tr;
    private final DatasetGraphCreator dgc;

    public FXWorker(TriplifierRegister tr, DatasetGraphCreator dgc) {
        this.tr = tr;
        this.dgc = dgc;
    }

    public QueryIterator execute(T op, QueryIterator input, ExecutionContext executionContext) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException, TriplifierHTTPException, IOException, UnboundVariableException {
        Properties p = new Properties();
        PropertyExtractor.extractPropertiesFromExecutionContext(executionContext, p);
        this.extractProperties(p, op);
        this.readFromStdIn(p);
        Triplifier t = PropertyExtractor.getTriplifier(p, this.tr);
        if (t == null) {
            logger.warn("No triplifier found");
            return QueryIterNullIterator.create((ExecutionContext)executionContext);
        }
        if (PropertyUtils.getBooleanProperty((Properties)p, (IRIArgument)IRIArgument.SLICE)) {
            if (t instanceof Slicer) {
                logger.trace("Execute with slicing");
                return new QueryIterSlicer(executionContext, input, t, p, (Op)op);
            }
            logger.warn("Slicing is not supported by triplifier: {}", (Object)t.getClass().getName());
        }
        DatasetGraph dg = this.dgc.getDatasetGraph(t, p, (Op)op);
        Utils.ensureReadingTxn(dg);
        return this.execute(op, input, executionContext, dg, p);
    }

    public abstract void extractProperties(Properties var1, T var2) throws UnboundVariableException;

    private void readFromStdIn(Properties p) {
        if (p.containsKey(IRIArgument.READ_FROM_STD_IN.toString())) {
            Scanner sc = new Scanner(System.in);
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine());
                sb.append('\n');
            }
            p.setProperty(IRIArgument.CONTENT.toString(), sb.substring(0, sb.length() - 1));
        }
    }

    public abstract QueryIterator execute(T var1, QueryIterator var2, ExecutionContext var3, DatasetGraph var4, Properties var5);
}

