/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.FacadeX;
import io.github.sparqlanything.engine.PropertyExtractor;
import io.github.sparqlanything.metadata.MetadataTriplifier;
import io.github.sparqlanything.model.BaseFacadeXGraphBuilder;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.TripleFilteringFacadeXGraphBuilder;
import io.github.sparqlanything.model.Triplifier;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.VOID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphCreator {
    private static final Logger logger = LoggerFactory.getLogger(DatasetGraphCreator.class);
    private final MetadataTriplifier metadataTriplifier = new MetadataTriplifier();
    private final ExecutionContext execCxt;

    public DatasetGraphCreator(ExecutionContext execCxt) {
        this.execCxt = execCxt;
    }

    public DatasetGraph getDatasetGraph(Triplifier t, Properties p, Op op) throws IOException {
        boolean useCache;
        if (t == null) {
            return DatasetGraphFactory.create();
        }
        boolean bl = useCache = !PropertyUtils.getBooleanProperty((Properties)p, (IRIArgument)IRIArgument.USE_CACHE);
        if (useCache && FacadeX.executedFacadeXIris.containsKey(this.getInMemoryCacheKey(p, op))) {
            DatasetGraph dg = FacadeX.executedFacadeXIris.get(this.getInMemoryCacheKey(p, op));
            this.createAuditGraph(dg, p, true, op);
            return dg;
        }
        DatasetGraph dg = this.triplify(op, p, t);
        this.createAuditGraph(dg, p, false, op);
        this.createMetadataGraph(dg, p);
        dg.commit();
        dg.end();
        this.persistDatasetGraphInCache(p, op, dg, useCache);
        return dg;
    }

    private String getInMemoryCacheKey(Properties properties, Op op) {
        String key = properties.toString().concat(op.toString());
        logger.trace("Cache key {}", (Object)key);
        return key;
    }

    private void createAuditGraph(DatasetGraph dg, Properties p, boolean b, Op op) {
        if (PropertyUtils.getBooleanProperty((Properties)p, (IRIArgument)IRIArgument.AUDIT)) {
            String SD = "http://www.w3.org/ns/sparql-service-description#";
            Model audit = ModelFactory.createDefaultModel();
            Resource root = audit.createResource("http://sparql.xyz/facade-x/data/audit#root");
            Node nodeGraph = NodeFactory.createURI((String)"http://sparql.xyz/facade-x/data/audit");
            if (dg.containsGraph(nodeGraph)) {
                HashSet graphNodes = new HashSet();
                dg.find(nodeGraph, null, NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/cachedGraph"), null).forEachRemaining(q -> graphNodes.add(q.getSubject()));
                for (Node g : graphNodes) {
                    dg.delete(nodeGraph, g, NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/cachedGraph"), NodeFactory.createLiteralByValue((Object)false));
                    dg.add(nodeGraph, g, NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/cachedGraph"), NodeFactory.createLiteralByValue((Object)true));
                }
                return;
            }
            Iterator graphs = dg.listGraphNodes();
            while (graphs.hasNext()) {
                Node g = (Node)graphs.next();
                Resource auditGraph = audit.createResource(g.getURI());
                root.addProperty(ResourceFactory.createProperty((String)SD.concat("namedGraph")), (RDFNode)auditGraph);
                auditGraph.addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)SD.concat("NamedGraph")));
                auditGraph.addProperty(ResourceFactory.createProperty((String)SD.concat("name")), g.getURI());
                auditGraph.addLiteral(VOID.triples, (long)dg.getGraph(g).size());
                auditGraph.addLiteral(auditGraph.getModel().createProperty("http://sparql.xyz/facade-x/ns/cachedGraph"), b);
                auditGraph.addProperty(auditGraph.getModel().createProperty("http://sparql.xyz/facade-x/ns/cachedGraphCreation"), new XSDDateTime(Calendar.getInstance()).toString(), (RDFDatatype)XSDDatatype.XSDdateTime);
                auditGraph.addProperty(auditGraph.getModel().createProperty("http://sparql.xyz/facade-x/ns/sparqlAlgebra"), op.toString());
            }
            dg.addGraph(nodeGraph, audit.getGraph());
        }
    }

    private DatasetGraph triplify(Op op, Properties p, Triplifier t) throws IOException {
        DatasetGraph dg;
        Integer strategy = PropertyExtractor.detectStrategy(p, this.execCxt);
        String resourceId = Triplifier.getResourceId((Properties)p);
        logger.debug("Execution strategy: {} {}", (Object)strategy, (Object)op.toString());
        if (t != null) {
            try {
                BaseFacadeXGraphBuilder builder;
                if (strategy == 1) {
                    logger.trace("Executing: {} [strategy={}]", (Object)p, (Object)strategy);
                    builder = new TripleFilteringFacadeXGraphBuilder(resourceId, op, p);
                } else {
                    logger.trace("Executing: {} [strategy={}]", (Object)p, (Object)strategy);
                    builder = new BaseFacadeXGraphBuilder(p);
                }
                t.triplify(p, (FacadeXGraphBuilder)builder);
                dg = builder.getDatasetGraph();
            }
            catch (Exception e) {
                if (p.containsKey(IRIArgument.OP_SERVICE_SILENT.toString()) && p.getProperty(IRIArgument.OP_SERVICE_SILENT.toString()).equals("true")) {
                    logger.warn("Errors encountered but the silent keyword was specified. Returning empty graph.");
                    dg = DatasetFactory.create().asDatasetGraph();
                }
                throw new IOException(e);
            }
        } else {
            logger.error("No triplifier available for the input format! Returning empty graph.");
            dg = DatasetFactory.create().asDatasetGraph();
        }
        return dg;
    }

    private void createMetadataGraph(DatasetGraph dg, Properties p) throws IOException {
        if (this.triplifyMetadata(p)) {
            BaseFacadeXGraphBuilder builder = new BaseFacadeXGraphBuilder(p);
            this.metadataTriplifier.triplify(p, (FacadeXGraphBuilder)builder);
            dg.addGraph(NodeFactory.createURI((String)"http://sparql.xyz/facade-x/data/metadata"), builder.getDatasetGraph().getDefaultGraph());
        }
    }

    private void persistDatasetGraphInCache(Properties p, Op op, DatasetGraph dg, boolean useCache) {
        if (useCache && !FacadeX.executedFacadeXIris.containsKey(this.getInMemoryCacheKey(p, op))) {
            FacadeX.executedFacadeXIris.put(this.getInMemoryCacheKey(p, op), dg);
            logger.debug("Graph added to in-memory cache");
        }
    }

    private boolean triplifyMetadata(Properties p) {
        boolean result = false;
        if (p.containsKey(IRIArgument.METADATA.toString())) {
            try {
                result = Boolean.parseBoolean(p.getProperty(IRIArgument.METADATA.toString()));
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }
}

