/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnySlot
extends PFuncSimple {
    private static final Logger logger = LoggerFactory.getLogger(AnySlot.class);

    public QueryIterator execEvaluated(final Binding parent, final Node subject, Node predicate, final Node object, ExecutionContext execCxt) {
        Node s = !subject.isVariable() ? subject : Node.ANY;
        Node o = !object.isVariable() ? object : Node.ANY;
        final ExtendedIterator it = execCxt.getActiveGraph().find(s, Node.ANY, o);
        logger.trace("S {} {} P {} O {} {} BP {} : {}", new Object[]{subject.toString(), s.toString(), predicate.toString(), object.toString(), o.toString(), Utils.bindingToString(parent), it.hasNext()});
        QueryIterator res = QueryIterPlainWrapper.create((Iterator)new Iterator<Binding>(){
            private Triple cached;
            private boolean hasCached;

            @Override
            public Binding next() {
                if (this.hasCached) {
                    this.hasCached = false;
                    return this.bindTriple(this.cached);
                }
                this.cached = this.fillNext();
                if (this.cached != null) {
                    return this.bindTriple(this.cached);
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasCached) {
                    return true;
                }
                this.cached = this.fillNext();
                if (this.cached != null) {
                    this.hasCached = true;
                    return true;
                }
                return false;
            }

            private Triple fillNext() {
                while (it.hasNext()) {
                    Triple t = (Triple)it.next();
                    if (!t.getPredicate().getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
                    return t;
                }
                return null;
            }

            private Binding bindTriple(Triple t) {
                BindingBuilder bb = Binding.builder((Binding)parent);
                if (subject.isVariable()) {
                    if (parent.contains((Var)subject)) {
                        bb.add((Var)subject, parent.get((Var)subject));
                    } else {
                        bb.add((Var)subject, t.getSubject());
                    }
                }
                if (object.isVariable()) {
                    if (parent.contains((Var)object)) {
                        bb.add((Var)subject, t.getSubject());
                    } else {
                        bb.add((Var)object, t.getObject());
                    }
                }
                return bb.build();
            }
        });
        return res;
    }
}

