/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.zip;

import com.google.common.collect.Sets;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.model.annotations.Example;
import io.github.sparqlanything.model.annotations.Option;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.jena.graph.NodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@io.github.sparqlanything.model.annotations.Triplifier
public class ZipTriplifier
implements Triplifier {
    private static Logger logger = LoggerFactory.getLogger(ZipTriplifier.class);
    @Example(resource="https://sparql-anything.cc/examples/example.tar", description="Select and triplify only .csv and .txt files within the archive.", query="PREFIX xyz: <http://sparql.xyz/facade-x/data/> PREFIX fx: <http://sparql.xyz/facade-x/ns/> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> CONSTRUCT { ?s1 ?p1 ?o1 . } WHERE { SERVICE <x-sparql-anything:location=https://sparql-anything.cc/examples/example.tar> { fx:properties fx:archive.matches \".*txt|.*csv\" . ?s fx:anySlot ?file1 SERVICE <x-sparql-anything:> { fx:properties fx:location ?file1 ; fx:from-archive \"https://sparql-anything.cc/examples/example.tar\" . ?s1 ?p1 ?o1 } } }")
    @Option(description="It tells sparql.anything to evaluate a regular expression on the filenames within the archives. In this case the slots will be filled with the files that match the regex only.", validValues="Any valid regular expression")
    public static final IRIArgument MATCHES = new IRIArgument("archive.matches", ".*");

    public void triplify(Properties properties, FacadeXGraphBuilder builder) throws IOException {
        ZipEntry ze;
        URL url = Triplifier.getLocation((Properties)properties);
        if (url == null) {
            logger.warn("No location provided");
            return;
        }
        String dataSourceId = "";
        Charset charset = Triplifier.getCharsetArgument((Properties)properties);
        String matches = PropertyUtils.getStringProperty((Properties)properties, (IRIArgument)MATCHES);
        builder.addRoot(dataSourceId);
        ZipInputStream zis = new ZipInputStream(url.openStream(), charset);
        int i = 1;
        while ((ze = zis.getNextEntry()) != null) {
            if (!ze.getName().matches(matches)) continue;
            builder.addValue(dataSourceId, "", Integer.valueOf(i), (Object)NodeFactory.createLiteralString((String)ze.getName()));
            ++i;
        }
        zis.close();
    }

    public Set<String> getMimeTypes() {
        return Sets.newHashSet((Object[])new String[]{"application/zip"});
    }

    public Set<String> getExtensions() {
        return Sets.newHashSet((Object[])new String[]{"zip"});
    }
}

