/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.zip;

import com.google.common.collect.Sets;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.zip.ZipTriplifier;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@io.github.sparqlanything.model.annotations.Triplifier
public class TarTriplifier
implements Triplifier {
    private static Logger logger = LoggerFactory.getLogger(TarTriplifier.class);

    public void triplify(Properties properties, FacadeXGraphBuilder builder) throws IOException {
        URL location = Triplifier.getLocation((Properties)properties);
        if (location == null) {
            logger.warn("No location provided");
            return;
        }
        Charset charset = Triplifier.getCharsetArgument((Properties)properties);
        String dataSourceId = "";
        String matches = PropertyUtils.getStringProperty((Properties)properties, (IRIArgument)ZipTriplifier.MATCHES);
        logger.trace("Matches {}", (Object)matches);
        builder.addRoot(dataSourceId);
        try {
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", location.openStream(), charset.toString());
            int i = 1;
            TarArchiveEntry entry = null;
            while ((entry = debInputStream.getNextEntry()) != null) {
                if (!entry.getName().matches(matches)) continue;
                builder.addValue(dataSourceId, "", Integer.valueOf(i), (Object)entry.getName());
                ++i;
            }
            debInputStream.close();
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    public Set<String> getMimeTypes() {
        return Sets.newHashSet((Object[])new String[]{"application/x-tar"});
    }

    public Set<String> getExtensions() {
        return Sets.newHashSet((Object[])new String[]{"tar"});
    }
}

