/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.zip;

import com.google.common.collect.Sets;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.zip.ZipTriplifier;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@io.github.sparqlanything.model.annotations.Triplifier
public class FolderTriplifier
implements Triplifier {
    private static Logger logger = LoggerFactory.getLogger(FolderTriplifier.class);

    public void triplify(Properties properties, FacadeXGraphBuilder builder) throws IOException {
        URL url = Triplifier.getLocation((Properties)properties);
        if (url == null) {
            logger.warn("No location provided");
            return;
        }
        String dataSourceId = "";
        String matches = PropertyUtils.getStringProperty((Properties)properties, (IRIArgument)ZipTriplifier.MATCHES);
        logger.trace("Matches {}", (Object)matches);
        builder.addRoot(dataSourceId);
        try {
            Path path = Paths.get(url.toURI());
            AtomicInteger i = new AtomicInteger(1);
            Files.walk(path, new FileVisitOption[0]).forEach(p -> {
                logger.trace("{} matches? {}", (Object)p.toString(), (Object)path.toString().matches(matches));
                if (p.toString().matches(matches)) {
                    builder.addValue(dataSourceId, "", Integer.valueOf(i.getAndIncrement()), (Object)p.toUri().toString());
                }
            });
        }
        catch (URISyntaxException e) {
            logger.error("", (Throwable)e);
        }
    }

    public Set<String> getMimeTypes() {
        return Sets.newHashSet();
    }

    public Set<String> getExtensions() {
        return Sets.newHashSet();
    }
}

