package dev.langchain4j.observability.api.event;

import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.observability.event.DefaultOutputGuardrailExecutedEvent;

/**
 * Represents an event executed during the output guardrail validation process.
 * This event serves as a marker to encapsulate the request, result, and implementation
 * of the output guardrail validation logic.
 *
 * This interface is specifically intended for use in scenarios where validation
 * logic operates on output responses generated by the LLM, ensuring the responses
 * meet predefined criteria or rules.
 */
public interface OutputGuardrailExecutedEvent
        extends GuardrailExecutedEvent<OutputGuardrailRequest, OutputGuardrailResult, OutputGuardrail> {

    @Override
    default Class<OutputGuardrailExecutedEvent> eventClass() {
        return OutputGuardrailExecutedEvent.class;
    }

    @Override
    default OutputGuardrailExecutedEventBuilder toBuilder() {
        return new OutputGuardrailExecutedEventBuilder(this);
    }

    static OutputGuardrailExecutedEventBuilder builder() {
        return new OutputGuardrailExecutedEventBuilder();
    }

    /**
     * Builder for {@link OutputGuardrailExecutedEvent} instances.
     */
    class OutputGuardrailExecutedEventBuilder
            extends GuardrailExecutedEventBuilder<
                    OutputGuardrailRequest, OutputGuardrailResult, OutputGuardrail, OutputGuardrailExecutedEvent> {
        protected OutputGuardrailExecutedEventBuilder() {}

        /**
         * Creates a builder initialized from an existing {@link OutputGuardrailExecutedEvent}.
         */
        protected OutputGuardrailExecutedEventBuilder(OutputGuardrailExecutedEvent src) {
            super(src);
        }

        /**
         * Builds a {@link OutputGuardrailExecutedEvent}.
         */
        @Override
        public OutputGuardrailExecutedEvent build() {
            return new DefaultOutputGuardrailExecutedEvent(this);
        }
    }
}
