/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStatsStage;
import co.elastic.clients.elasticsearch.snapshot.ShardsStatsSummary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotShardsStatus
implements JsonpSerializable {
    private final ShardsStatsStage stage;
    private final ShardsStatsSummary stats;
    public static final JsonpDeserializer<SnapshotShardsStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotShardsStatus::setupSnapshotShardsStatusDeserializer);

    private SnapshotShardsStatus(Builder builder) {
        this.stage = ApiTypeHelper.requireNonNull(builder.stage, this, "stage");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
    }

    public static SnapshotShardsStatus of(Function<Builder, ObjectBuilder<SnapshotShardsStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardsStatsStage stage() {
        return this.stage;
    }

    public final ShardsStatsSummary stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stage");
        this.stage.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSnapshotShardsStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stage, ShardsStatsStage._DESERIALIZER, "stage");
        op.add(Builder::stats, ShardsStatsSummary._DESERIALIZER, "stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotShardsStatus> {
        private ShardsStatsStage stage;
        private ShardsStatsSummary stats;

        public final Builder stage(ShardsStatsStage value) {
            this.stage = value;
            return this;
        }

        public final Builder stats(ShardsStatsSummary value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<ShardsStatsSummary.Builder, ObjectBuilder<ShardsStatsSummary>> fn) {
            return this.stats(fn.apply(new ShardsStatsSummary.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotShardsStatus build() {
            this._checkSingleUse();
            return new SnapshotShardsStatus(this);
        }
    }
}

