/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.SamlLogoutResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamlLogoutRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String refreshToken;
    private final String token;
    public static final JsonpDeserializer<SamlLogoutRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlLogoutRequest::setupSamlLogoutRequestDeserializer);
    public static final Endpoint<SamlLogoutRequest, SamlLogoutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SamlLogoutRequest, SamlLogoutResponse>("es/security.saml_logout", request -> "POST", request -> "/_security/saml/logout", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SamlLogoutResponse._DESERIALIZER);

    private SamlLogoutRequest(Builder builder) {
        this.refreshToken = builder.refreshToken;
        this.token = ApiTypeHelper.requireNonNull(builder.token, this, "token");
    }

    public static SamlLogoutRequest of(Function<Builder, ObjectBuilder<SamlLogoutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String token() {
        return this.token;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        generator.writeKey("token");
        generator.write(this.token);
    }

    protected static void setupSamlLogoutRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SamlLogoutRequest> {
        @Nullable
        private String refreshToken;
        private String token;

        public final Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder token(String value) {
            this.token = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamlLogoutRequest build() {
            this._checkSingleUse();
            return new SamlLogoutRequest(this);
        }
    }
}

