/*
 * Decompiled with CFR 0.152.
 */
package com.mobi.persistence.utils.impl;

import com.mobi.persistence.utils.api.BNodeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={BNodeService.class})
public class SimpleBNodeService
implements BNodeService {
    private static final String PATH_COMPONENT = "/.well-known/genid/";
    public static final String SKOLEMIZED_NAMESPACE = "http://mobi.com/.well-known/genid/";
    public final ValueFactory vf = SimpleValueFactory.getInstance();
    public final ModelFactory mf = new DynamicModelFactory();

    @Override
    public IRI skolemize(BNode bnode) {
        return this.vf.createIRI(SKOLEMIZED_NAMESPACE, bnode.getID());
    }

    @Override
    public Value skolemize(Value value) {
        return value instanceof BNode ? this.skolemize((BNode)value) : value;
    }

    @Override
    public Statement skolemize(Statement statement) {
        Resource context;
        Value object;
        boolean skolemized = false;
        Resource subject = statement.getSubject();
        if (subject instanceof BNode) {
            subject = this.skolemize((BNode)subject);
            skolemized = true;
        }
        if ((object = statement.getObject()) instanceof BNode) {
            object = this.skolemize((BNode)object);
            skolemized = true;
        }
        if ((context = statement.getContext()) instanceof BNode) {
            context = this.skolemize((BNode)context);
            skolemized = true;
        }
        return skolemized ? this.vf.createStatement(subject, statement.getPredicate(), object, context) : statement;
    }

    @Override
    public Model skolemize(Model model) {
        Model result = this.mf.createEmptyModel();
        model.forEach(statement -> result.add((Object)this.skolemize((Statement)statement)));
        return result;
    }

    @Override
    public Model deterministicSkolemize(Model model) {
        HashMap<BNode, IRI> skolemizedBNodes = new HashMap<BNode, IRI>();
        return this.deterministicSkolemize(model, skolemizedBNodes);
    }

    @Override
    public Model deterministicSkolemize(Model model, Map<BNode, IRI> skolemizedBNodes) {
        Model result = this.mf.createEmptyModel();
        HashMap hashCount = new HashMap();
        model.subjects().stream().filter(IRI.class::isInstance).sorted(Comparator.comparing(Value::stringValue)).forEach(resource -> model.filter(resource, null, null, new Resource[]{null}).stream().sorted(new ModelStatementComparator(model)).forEach(statement -> {
            if (statement.getObject() instanceof BNode) {
                if (!skolemizedBNodes.containsKey(statement.getObject())) {
                    HashSet<BNode> visited = new HashSet<BNode>();
                    Model cycleStmts = this.mf.createEmptyModel();
                    result.addAll((Collection)this.deterministicSkolemize((BNode)statement.getObject(), model, skolemizedBNodes, hashCount, visited, cycleStmts));
                }
                if (statement.getContext() != null) {
                    result.add(statement.getSubject(), statement.getPredicate(), (Value)skolemizedBNodes.get(statement.getObject()), new Resource[]{statement.getContext()});
                } else {
                    result.add(statement.getSubject(), statement.getPredicate(), (Value)skolemizedBNodes.get(statement.getObject()), new Resource[0]);
                }
            } else {
                result.add(statement);
            }
        }));
        model.subjects().stream().filter(resource -> resource instanceof BNode && !skolemizedBNodes.containsKey(resource)).forEach(resource -> {
            HashSet<BNode> visited = new HashSet<BNode>();
            Model cycleStmts = this.mf.createEmptyModel();
            result.addAll((Collection)this.deterministicSkolemize((BNode)resource, model, skolemizedBNodes, hashCount, visited, cycleStmts));
        });
        return result;
    }

    private Model deterministicSkolemize(BNode bNode, Model model, Map<BNode, IRI> skolemizedBNodes, Map<Long, Integer> hashCount, Set<BNode> visited, Model cycleStmts) {
        Object hashString;
        Model result = this.mf.createEmptyModel();
        visited.add(bNode);
        ArrayList valuesToHash = new ArrayList();
        model.filter((Resource)bNode, null, null, new Resource[]{null}).stream().sorted(new ModelStatementComparator(model)).forEach(statement -> {
            IRI predicate = statement.getPredicate();
            Value value = statement.getObject();
            if (value instanceof BNode) {
                if (visited.contains(value)) {
                    cycleStmts.add(statement);
                } else {
                    if (!skolemizedBNodes.containsKey(value)) {
                        result.addAll((Collection)this.deterministicSkolemize((BNode)value, model, skolemizedBNodes, hashCount, visited, cycleStmts));
                    }
                    valuesToHash.add(predicate.stringValue());
                    valuesToHash.add(((IRI)skolemizedBNodes.get(value)).stringValue());
                }
            } else {
                valuesToHash.add(predicate.stringValue());
                valuesToHash.add(value.stringValue());
            }
        });
        Collections.sort(valuesToHash);
        long idHash = SimpleBNodeService.hash(String.join((CharSequence)"", valuesToHash));
        if (hashCount.containsKey(idHash)) {
            int nextValue = hashCount.get(idHash) + 1;
            hashString = idHash + "-" + nextValue;
            hashCount.put(idHash, nextValue);
        } else {
            hashString = String.valueOf(idHash);
            hashCount.put(idHash, 1);
        }
        IRI skolemizedIRI = this.vf.createIRI(SKOLEMIZED_NAMESPACE, (String)hashString);
        model.filter((Resource)bNode, null, null, new Resource[]{null}).stream().filter(statement -> !cycleStmts.contains(statement)).forEach(statement -> {
            Value value;
            Value value2 = value = statement.getObject() instanceof BNode ? (Value)skolemizedBNodes.get(statement.getObject()) : statement.getObject();
            if (statement.getContext() != null) {
                result.add((Resource)skolemizedIRI, statement.getPredicate(), value, new Resource[]{statement.getContext()});
            } else {
                result.add((Resource)skolemizedIRI, statement.getPredicate(), value, new Resource[0]);
            }
        });
        cycleStmts.filter(null, null, (Value)bNode, new Resource[]{null}).forEach(statement -> {
            if (statement.getContext() != null) {
                result.add((Resource)skolemizedBNodes.get(statement.getSubject()), statement.getPredicate(), (Value)skolemizedIRI, new Resource[]{statement.getContext()});
            } else {
                result.add((Resource)skolemizedBNodes.get(statement.getSubject()), statement.getPredicate(), (Value)skolemizedIRI, new Resource[0]);
            }
        });
        skolemizedBNodes.put(bNode, skolemizedIRI);
        return result;
    }

    @Override
    public BNode deskolemize(IRI iri) {
        return this.vf.createBNode(iri.getLocalName());
    }

    @Override
    public Value deskolemize(Value value) {
        return this.isSkolemized(value) ? this.deskolemize((IRI)value) : value;
    }

    @Override
    public Statement deskolemize(Statement statement) {
        Resource context;
        Value object;
        boolean deskolemized = false;
        Resource subject = statement.getSubject();
        if (this.isSkolemized((Value)subject)) {
            subject = this.deskolemize((IRI)subject);
            deskolemized = true;
        }
        if (this.isSkolemized(object = statement.getObject())) {
            object = this.deskolemize((IRI)object);
            deskolemized = true;
        }
        if (this.isSkolemized((Value)(context = statement.getContext()))) {
            context = this.deskolemize((IRI)context);
            deskolemized = true;
        }
        return deskolemized ? this.vf.createStatement(subject, statement.getPredicate(), object, context) : statement;
    }

    @Override
    public Model deskolemize(Model model) {
        Model result = this.mf.createEmptyModel();
        model.forEach(statement -> result.add((Object)this.deskolemize((Statement)statement)));
        return result;
    }

    private boolean isSkolemized(Value value) {
        return value instanceof IRI && ((IRI)value).getNamespace().contains(PATH_COMPONENT);
    }

    private static long hash(String string) {
        long hash = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            hash = 31L * hash + (long)string.charAt(i);
        }
        return hash;
    }

    private static class ModelStatementComparator
    implements Comparator<Statement> {
        private Model model;

        public ModelStatementComparator(Model model) {
            this.model = model;
        }

        public ModelStatementComparator compareBy(Model model) {
            this.model = model;
            return this;
        }

        @Override
        public int compare(Statement o1, Statement o2) {
            long o1Score = this.scoreValue(o1.getObject());
            long o2Score = this.scoreValue(o2.getObject());
            return Long.compare(o1Score, o2Score);
        }

        private long scoreValue(Value value) {
            if (value instanceof BNode) {
                ArrayList o1Values = new ArrayList();
                this.model.filter((Resource)((BNode)value), null, null, new Resource[]{null}).forEach(statement -> {
                    if (statement.getObject() instanceof BNode) {
                        o1Values.add(statement.getPredicate().stringValue());
                    } else {
                        o1Values.add(statement.getPredicate().stringValue());
                        o1Values.add(statement.getObject().stringValue());
                    }
                });
                Collections.sort(o1Values);
                return SimpleBNodeService.hash(String.join((CharSequence)"", o1Values));
            }
            return SimpleBNodeService.hash(value.stringValue());
        }
    }
}

